<?php

namespace Ovr\Form\Policies;

use Litepie\User\Contracts\UserPolicy;
use Ovr\Form\Models\Sale;

class SalePolicy
{

    /**
     * Determine if the given user can view the sale.
     *
     * @param UserPolicy $user
     * @param Sale $sale
     *
     * @return bool
     */
    public function view(UserPolicy $user, Sale $sale)
    {
        if ($user->canDo('form.sale.view') && $user->isAdmin()) {
            return true;
        }

        return $sale->user_id == user_id() && $sale->user_type == user_type();
    }

    /**
     * Determine if the given user can create a sale.
     *
     * @param UserPolicy $user
     * @param Sale $sale
     *
     * @return bool
     */
    public function create(UserPolicy $user)
    {
        return  $user->canDo('form.sale.create');
    }

    /**
     * Determine if the given user can update the given sale.
     *
     * @param UserPolicy $user
     * @param Sale $sale
     *
     * @return bool
     */
    public function update(UserPolicy $user, Sale $sale)
    {
        if ($user->canDo('form.sale.edit') && $user->isAdmin()) {
            return true;
        }

        return $sale->user_id == user_id() && $sale->user_type == user_type();
    }

    /**
     * Determine if the given user can delete the given sale.
     *
     * @param UserPolicy $user
     * @param Sale $sale
     *
     * @return bool
     */
    public function destroy(UserPolicy $user, Sale $sale)
    {
        return $sale->user_id == user_id() && $sale->user_type == user_type();
    }

    /**
     * Determine if the given user can verify the given sale.
     *
     * @param UserPolicy $user
     * @param Sale $sale
     *
     * @return bool
     */
    public function verify(UserPolicy $user, Sale $sale)
    {
        if ($user->canDo('form.sale.verify')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the given user can approve the given sale.
     *
     * @param UserPolicy $user
     * @param Sale $sale
     *
     * @return bool
     */
    public function approve(UserPolicy $user, Sale $sale)
    {
        if ($user->canDo('form.sale.approve')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the user can perform a given action ve.
     *
     * @param [type] $user    [description]
     * @param [type] $ability [description]
     *
     * @return [type] [description]
     */
    public function before($user, $ability)
    {
        if ($user->isSuperuser()) {
            return true;
        }
    }
}
