<?php

namespace Ovr\Form\Providers;

use Illuminate\Support\ServiceProvider;

class FormServiceProvider extends ServiceProvider
{
    /**
     * Indicates if loading of the provider is deferred.
     *
     * @var bool
     */
    protected $defer = false;

    /**
     * Bootstrap the application events.
     *
     * @return void
     */
    public function boot()
    {
        // Load view
        $this->loadViewsFrom(__DIR__ . '/../../resources/views', 'form');

        // Load translation
        $this->loadTranslationsFrom(__DIR__ . '/../../resources/lang', 'form');

        // Load migrations
        $this->loadMigrationsFrom(__DIR__ . '/../../database/migrations');

        // Call pblish redources function
        $this->publishResources();

    }

    /**
     * Register the service provider.
     *
     * @return void
     */
    public function register()
    {
        $this->mergeConfig();
        $this->registerForm();
        $this->registerFacade();
        $this->registerBindings();
        //$this->registerCommands();
    }


    /**
     * Register the application bindings.
     *
     * @return void
     */
    protected function registerForm()
    {
        $this->app->bind('form', function($app) {
            return new Form($app);
        });
    }

    /**
     * Register the vault facade without the user having to add it to the app.php file.
     *
     * @return void
     */
    public function registerFacade() {
        $this->app->booting(function()
        {
            $loader = \Illuminate\Foundation\AliasLoader::getInstance();
            $loader->alias('Form', 'Lavalite\Form\Facades\Form');
        });
    }

    /**
     * Register bindings for the provider.
     *
     * @return void
     */
    public function registerBindings() {
        // Bind facade
        $this->app->bind('ovr.form', function ($app) {
            return $this->app->make('Ovr\Form\Form');
        });

        // Bind Sale to repository
        $this->app->bind(
            'Ovr\Form\Interfaces\SaleRepositoryInterface',
            \Ovr\Form\Repositories\Eloquent\SaleRepository::class
        );        // Bind Example to repository
        $this->app->bind(
            'Ovr\Form\Interfaces\ExampleRepositoryInterface',
            \Ovr\Form\Repositories\Eloquent\ExampleRepository::class
        );

        $this->app->register(\Ovr\Form\Providers\AuthServiceProvider::class);
                $this->app->register(\Ovr\Form\Providers\EventServiceProvider::class);
        
        $this->app->register(\Ovr\Form\Providers\RouteServiceProvider::class);
            }

    /**
     * Merges user's and form's configs.
     *
     * @return void
     */
    protected function mergeConfig()
    {
        $this->mergeConfigFrom(
            __DIR__ . '/../../config/form.php', 'form'
        );
    }

    /**
     * Register scaffolding command
     */
    protected function registerCommands()
    {
        if ($this->app->runningInConsole()) {
            $this->commands([
                Commands\MakeForm::class,
            ]);
        }
    }
    /**
     * Get the services provided by the provider.
     *
     * @return array
     */
    public function provides()
    {
        return ['ovr.form'];
    }

    /**
     * Publish resources.
     *
     * @return void
     */
    private function publishResources()
    {
        // Publish configuration file
        $this->publishes([__DIR__ . '/../../config/config.php' => config_path('ovr/form.php')], 'config');

        // Publish admin view
        $this->publishes([__DIR__ . '/../../resources/views' => base_path('resources/views/vendor/form')], 'view');

        // Publish language files
        $this->publishes([__DIR__ . '/../../resources/lang' => base_path('resources/lang/vendor/form')], 'lang');

        // Publish public files and assets.
        $this->publishes([__DIR__ . '/public/' => public_path('/')], 'public');
    }
}
