<?php

namespace Ovr\Form\Repositories\Presenter;

use League\Fractal\TransformerAbstract;
use Hashids;

class SaleTransformer extends TransformerAbstract
{
    public function transform(\Ovr\Form\Models\Sale $sale)
    {
        return [
            'id'                => $sale->getRouteKey(),
            'key'               => [
                'public'    => $sale->getPublicKey(),
                'route'     => $sale->getRouteKey(),
            ], 
            'id'                => $sale->id,
            'user_id'           => $sale->user_id,
            'user_type'         => $sale->user_type,
            'product_id'        => $sale->product_id,
            'status'            => $sale->status,
            'price'             => $sale->price,
            'amount'            => $sale->amount,
            'quantity'          => $sale->quantity,
            'date'              => $sale->date,
            'url'               => [
                'public'    => trans_url('form/'.$sale->getPublicKey()),
                'user'      => guard_url('form/sale/'.$sale->getRouteKey()),
            ], 
            'status'            => trans('app.'.$sale->status),
            'created_at'        => format_date($sale->created_at),
            'updated_at'        => format_date($sale->updated_at),
        ];
    }
}