<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;

class CreateHelpsTable extends Migration
{
    /*
     * Run the migrations.
     *
     * @return void
     */

    public function up()
    {

        /*
         * Table: helps
         */
        Schema::create('helps', function ($table) {
            $table->increments('id');
            $table->string('unique_id', 150)->nullable();
            $table->string('user_name', 255)->nullable();
            $table->string('email', 255)->nullable();
            $table->integer('phone')->nullable();
            $table->text('address')->nullable();
            $table->text('message')->nullable();
            $table->text('file')->nullable();
            $table->text('current_url')->nullable();
            $table->text('browser_info')->nullable();
            $table->integer('slug')->nullable();
            $table->integer('user_id')->nullable();
            $table->string('user_type', 200)->nullable();
            $table->softDeletes();
            $table->nullableTimestamps();
        });
    }

    /*
    * Reverse the migrations.
    *
    * @return void
    */

    public function down()
    {
        Schema::drop('helps');
    }
}
