# Installation

The instructions below will help you to properly install the generated package to the lavalite project.

## Location

Extract the package contents to the folder 

`/packages/b2buy/help/`

## Composer

Add the below entries in the `composer.json` file's autoload section and run the command `composer dump-autoload` in terminal.

```json

...
     "autoload": {
         ...

        "classmap": [
            ...
            
            "packages/b2buy/help/database/seeds",
            
            ...
        ],
        "psr-4": {
            ...
            
            "B2buy\\Help\\": "packages/b2buy/help/src",
            
            ...
        }
    },
...

```

## Config

Add the entries in service provider in `config/app.php`

```php

...
    'providers'       => [
        ...
        
        B2buy\Help\Providers\HelpServiceProvider::class,
        
        ...
    ],

    ...

    'alias'             => [
        ...
        
        'Help'  => B2buy\Help\Facades\Help::class,
        
        ...
    ]
...

```

## Migrate

After service provider is set run the commapnd to migrate and seed the database.


    php artisan migrate
    php artisan db:seed --class=B2buy\\HelpTableSeeder

## Publishing


**Publishing configuration**

    php artisan vendor:publish --provider="B2buy\Help\Providers\HelpServiceProvider" --tag="config"

**Publishing language**

    php artisan vendor:publish --provider="B2buy\Help\Providers\HelpServiceProvider" --tag="lang"

**Publishing views**

    php artisan vendor:publish --provider="B2buy\Help\Providers\HelpServiceProvider" --tag="view"


## URLs and APIs


### Web Urls

**Admin**

    http://path-to-route-folder/admin/help/{modulename}

**User**

    http://path-to-route-folder/user/help/{modulename}

**Public**

    http://path-to-route-folder/helps


### API endpoints

**List**
 
    http://path-to-route-folder/api/user/help/{modulename}
    METHOD: GET

**Create**

    http://path-to-route-folder/api/user/help/{modulename}
    METHOD: POST

**Edit**

    http://path-to-route-folder/api/user/help/{modulename}/{id}
    METHOD: PUT

**Delete**

    http://path-to-route-folder/api/user/help/{modulename}/{id}
    METHOD: DELETE

**Public List**

    http://path-to-route-folder/api/help/{modulename}
    METHOD: GET

**Public Single**

    http://path-to-route-folder/api/help/{modulename}/{slug}
    METHOD: GET