Lavalite package that provides help management facility for the cms.

## Installation

Begin by installing this package through Composer. Edit your project's `composer.json` file to require `b2buy/help`.

    "b2buy/help": "dev-master"

Next, update Composer from the Terminal:

    composer update

Once this operation completes execute below cammnds in command line to finalize installation.

    B2buy\Help\Providers\HelpServiceProvider::class,

And also add it to alias

    'Help'  => B2buy\Help\Facades\Help::class,

## Publishing files and migraiting database.

**Migration and seeds**

    php artisan migrate
    php artisan db:seed --class=B2buy\\HelpTableSeeder

**Publishing configuration**

    php artisan vendor:publish --provider="B2buy\Help\Providers\HelpServiceProvider" --tag="config"

**Publishing language**

    php artisan vendor:publish --provider="B2buy\Help\Providers\HelpServiceProvider" --tag="lang"

**Publishing views**

    php artisan vendor:publish --provider="B2buy\Help\Providers\HelpServiceProvider" --tag="view"


### Web Urls

**Admin**

    http://path-to-route-folder/admin/help/{modulename}

**User**

    http://path-to-route-folder/user/help/{modulename}

**Public**

    http://path-to-route-folder/helps


### API endpoints

**List**

    http://path-to-route-folder/api/user/help/{modulename}
    METHOD: GET

**Create**

    http://path-to-route-folder/api/user/help/{modulename}
    METHOD: POST

**Edit**

    http://path-to-route-folder/api/user/help/{modulename}/{id}
    METHOD: PUT

**Delete**

    http://path-to-route-folder/api/user/help/{modulename}/{id}
    METHOD: DELETE

**Public List**

    http://path-to-route-folder/api/help/{modulename}
    METHOD: GET

**Public Single**

    http://path-to-route-folder/api/help/{modulename}/{slug}
    METHOD: GET