<?php

// API routes  for help
Route::prefix('{guard}/help')->group(function () {
    Route::get('help/form/{element}', 'HelpAPIController@form');
    Route::resource('help', 'HelpAPIController');
});

// Public routes for help
Route::get('helps/', 'HelpPublicController@index');
Route::get('helps/{slug?}', 'HelpPublicController@show');

if (Trans::isMultilingual()) {
    Route::group(
        [
            'prefix' => '{trans}',
            'where'  => ['trans' => Trans::keys('|')],
        ],
        function () {
            // Guard routes for helps
            Route::prefix('{guard}/help')->group(function () {
                Route::get('help/form/{element}', 'HelpAPIController@form');
                Route::apiResource('help', 'HelpAPIController');
            });
            // Public routes for helps
            Route::get('help/Help', 'HelpPublicController@getHelp');
        }
    );
}

