<?php

// web routes  for help
Route::prefix('{guard}/help')->group(function () {
    Route::resource('help', 'HelpResourceController');
});

// Public routes for help
Route::get('helps/', 'HelpPublicController@index');
Route::get('helps/{slug?}', 'HelpPublicController@show');

if (Trans::isMultilingual()) {
    Route::group(
        [
            'prefix' => '{trans}',
            'where'  => ['trans' => Trans::keys('|')],
        ],
        function () {
            // Guard routes for pages
            Route::prefix('{guard}/page')->group(function () {
                Route::apiResource('page', 'HelpResourceController');
            });
            // Public routes for pages
            Route::get('helps/', 'HelpPublicController@index');
            Route::get('helps/{slug?}', 'HelpPublicController@show');
        }
    );
}

