<?php

namespace B2buy\Help\Forms;

class Help
{
    /**
     * Variable to store form configuration.
     *
     * @var collection
     */
    protected $form;

    /**
     * Variable to store form configuration.
     *
     * @var collection
     */
    protected $element;

    /**
     * Initialize the form.
     *
     * @return null
     */
    public function __construct()
    {
        $this->setForm();
    }

    /**
     * Return form elements.
     *
     * @return array.
     */
    public function form($element = 'fields', $grouped = true)
    {
        $item = collect($this->form->get($element));
        if ($element == 'fields' && $grouped == true) {
            return $item->groupBy(['group', 'section']);
        }
        return $item;

    }

    /**
     * Sets the form and form elements.
     * @return null.
     */
    public function setForm()
    {
        $this->form = collect([
            'form' => [
                'store' => [],
                'update' => [],
            ],
            'groups' => [
                'main' => 'Main',
            ],
            'fields' => [
                'unique_id' => [
                    "type" => 'text',
                    "label" => trans('help::help.label.unique_id'),
                    "placeholder" => trans('help::help.placeholder.unique_id'),
                    "rules" => '',
                    "group" => "main",
                    "section" => "first",
                    "attributes" => [
                        'wrapper' => [],
                        "label" => [],
                        "input" => [],

                    ],
                ],
                'user_name' => [
                    "type" => 'text',
                    "label" => trans('help::help.label.user_name'),
                    "placeholder" => trans('help::help.placeholder.user_name'),
                    "rules" => '',
                    "group" => "main",
                    "section" => "first",
                    "attributes" => [
                        'wrapper' => [],
                        "label" => [],
                        "input" => [],

                    ],
                ],
                'email' => [
                    "type" => 'text',
                    "label" => trans('help::help.label.email'),
                    "placeholder" => trans('help::help.placeholder.email'),
                    "rules" => '',
                    "group" => "main",
                    "section" => "first",
                    "attributes" => [
                        'wrapper' => [],
                        "label" => [],
                        "input" => [],

                    ],
                ],
                'phone' => [
                    "type" => 'numeric',
                    "label" => trans('help::help.label.phone'),
                    "placeholder" => trans('help::help.placeholder.phone'),
                    "rules" => '',
                    "group" => "main",
                    "section" => "first",
                    "attributes" => [
                        'wrapper' => [],
                        "label" => [],
                        "input" => [],

                    ],
                ],
                'address' => [
                    "type" => 'text',
                    "label" => trans('help::help.label.address'),
                    "placeholder" => trans('help::help.placeholder.address'),
                    "rules" => '',
                    "group" => "main",
                    "section" => "first",
                    "attributes" => [
                        'wrapper' => [],
                        "label" => [],
                        "input" => [],

                    ],
                ],
                'message' => [
                    "type" => 'text',
                    "label" => trans('help::help.label.message'),
                    "placeholder" => trans('help::help.placeholder.message'),
                    "rules" => '',
                    "group" => "main",
                    "section" => "first",
                    "attributes" => [
                        'wrapper' => [],
                        "label" => [],
                        "input" => [],

                    ],
                ],
                'file' => [
                    "type" => 'text',
                    "label" => trans('help::help.label.file'),
                    "placeholder" => trans('help::help.placeholder.file'),
                    "rules" => '',
                    "group" => "main",
                    "section" => "first",
                    "attributes" => [
                        'wrapper' => [],
                        "label" => [],
                        "input" => [],

                    ],
                ],
                'current_url' => [
                    "type" => 'text',
                    "label" => trans('help::help.label.current_url'),
                    "placeholder" => trans('help::help.placeholder.current_url'),
                    "rules" => '',
                    "group" => "main",
                    "section" => "first",
                    "attributes" => [
                        'wrapper' => [],
                        "label" => [],
                        "input" => [],

                    ],
                ],
                'browser_info' => [
                    "type" => 'text',
                    "label" => trans('help::help.label.browser_info'),
                    "placeholder" => trans('help::help.placeholder.browser_info'),
                    "rules" => '',
                    "group" => "main",
                    "section" => "first",
                    "attributes" => [
                        'wrapper' => [],
                        "label" => [],
                        "input" => [],

                    ],
                ],
            ]
        );

    }
}
