<?php

namespace B2buy\Help;

use User;

class Help
{
    /**
     * $help object.
     */
    protected $help;

    /**
     * Constructor.
     */
    public function __construct(\B2buy\Help\Interfaces\HelpRepositoryInterface $help)
    {
        $this->help = $help;
    }

    /**
     * Returns count of help.
     *
     * @param array $filter
     *
     * @return int
     */
    public function count()
    {
        return  0;
    }

    /**
     * Make gadget View
     *
     * @param string $view
     *
     * @param int $count
     *
     * @return View
     */
    public function gadget($view = 'admin.help.gadget', $count = 10)
    {

        if (User::hasRole('user')) {
            $this->help->pushCriteria(new \Litepie\B2buy\Repositories\Criteria\HelpUserCriteria());
        }

        $help = $this->help->scopeQuery(function ($query) use ($count) {
            return $query->orderBy('id', 'DESC')->take($count);
        })->all();

        return view('help::' . $view, compact('help'))->render();
    }
}
