<?php

namespace B2buy\Help\Http\Controllers;

use App\Http\Controllers\PublicController as BaseController;
use B2buy\Help\Interfaces\HelpRepositoryInterface;

class HelpPublicController extends BaseController
{
    // use HelpWorkflow;

    /**
     * Constructor.
     *
     * @param type \B2buy\Help\Interfaces\HelpRepositoryInterface $help
     *
     * @return type
     */
    public function __construct(HelpRepositoryInterface $help)
    {
        $this->repository = $help;
        parent::__construct();
    }

    /**
     * Show help's list.
     *
     * @param string $slug
     *
     * @return response
     */
    protected function index()
    {
        $helps = $this->repository
        ->pushCriteria(app('Litepie\Repository\Criteria\RequestCriteria'))
        ->scopeQuery(function($query){
            return $query->orderBy('id','DESC');
        })->paginate();


        return $this->response->setMetaTitle(trans('help::help.names'))
            ->view('help::public.help.index')
            ->data(compact('helps'))
            ->output();
    }


    /**
     * Show help.
     *
     * @param string $slug
     *
     * @return response
     */
    protected function show($slug)
    {
        $help = $this->repository->scopeQuery(function($query) use ($slug) {
            return $query->orderBy('id','DESC')
                         ->where('slug', $slug);
        })->first(['*']);

        return $this->response->setMetaTitle($help->name . trans('help::help.name'))
            ->view('help::public.help.show')
            ->data(compact('help'))
            ->output();
    }

}
