<?php

namespace B2buy\Help\Policies;

use Litepie\User\Contracts\UserPolicy;
use B2buy\Help\Models\Help;

class HelpPolicy
{

    /**
     * Determine if the given user can view the help.
     *
     * @param UserPolicy $user
     * @param Help $help
     *
     * @return bool
     */
    public function view(UserPolicy $user, Help $help)
    {
        if ($user->canDo('help.help.view') && $user->isAdmin()) {
            return true;
        }

        return $help->user_id == user_id() && $help->user_type == user_type();
    }

    /**
     * Determine if the given user can create a help.
     *
     * @param UserPolicy $user
     * @param Help $help
     *
     * @return bool
     */
    public function create(UserPolicy $user)
    {
        return  $user->canDo('help.help.create');
    }

    /**
     * Determine if the given user can update the given help.
     *
     * @param UserPolicy $user
     * @param Help $help
     *
     * @return bool
     */
    public function update(UserPolicy $user, Help $help)
    {
        if ($user->canDo('help.help.edit') && $user->isAdmin()) {
            return true;
        }

        return $help->user_id == user_id() && $help->user_type == user_type();
    }

    /**
     * Determine if the given user can delete the given help.
     *
     * @param UserPolicy $user
     * @param Help $help
     *
     * @return bool
     */
    public function destroy(UserPolicy $user, Help $help)
    {
        return $help->user_id == user_id() && $help->user_type == user_type();
    }

    /**
     * Determine if the given user can verify the given help.
     *
     * @param UserPolicy $user
     * @param Help $help
     *
     * @return bool
     */
    public function verify(UserPolicy $user, Help $help)
    {
        if ($user->canDo('help.help.verify')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the given user can approve the given help.
     *
     * @param UserPolicy $user
     * @param Help $help
     *
     * @return bool
     */
    public function approve(UserPolicy $user, Help $help)
    {
        if ($user->canDo('help.help.approve')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the user can perform a given action ve.
     *
     * @param [type] $user    [description]
     * @param [type] $ability [description]
     *
     * @return [type] [description]
     */
    public function before($user, $ability)
    {
        if ($user->isSuperuser()) {
            return true;
        }
    }
}
