<?php

namespace B2buy\Help\Repositories\Presenter;

use League\Fractal\TransformerAbstract;
use Hashids;

class HelpTransformer extends TransformerAbstract
{
    public function transform(\B2buy\Help\Models\Help $help)
    {
        return [
            'id'                => $help->getRouteKey(),
            'key'               => [
                'public'    => $help->getPublicKey(),
                'route'     => $help->getRouteKey(),
            ], 
            'unique_id'         => $help->unique_id,
            'user_name'         => $help->user_name,
            'email'             => $help->email,
            'phone'             => $help->phone,
            'address'           => $help->address,
            'message'           => $help->message,
            'file'              => $help->file,
            'current_url'       => $help->current_url,
            'browser_info'      => $help->browser_info,
            'slug'              => $help->slug,
            'user_id'           => $help->user_id,
            'user_type'         => $help->user_type,
            'deleted_at'        => $help->deleted_at,
            'url'               => [
                'public'    => trans_url('help/'.$help->getPublicKey()),
                'user'      => guard_url('help/help/'.$help->getRouteKey()),
            ], 
            'status'            => trans('app.'.$help->status),
            'created_at'        => format_date($help->created_at),
            'updated_at'        => format_date($help->updated_at),
        ];
    }
}