<?php

// API routes  for blog
Route::prefix('{guard}/blog')->group(function () {
    Route::get('blog/form/{element}', 'BlogAPIController@form');
    Route::resource('blog', 'BlogAPIController');
});

// Public routes for blog
Route::get('blogs/', 'BlogPublicController@index');
Route::get('blogs/{slug?}', 'BlogPublicController@show');

if (Trans::isMultilingual()) {
    Route::group(
        [
            'prefix' => '{trans}',
            'where'  => ['trans' => Trans::keys('|')],
        ],
        function () {
            // Guard routes for blogs
            Route::prefix('{guard}/blog')->group(function () {
                Route::get('blog/form/{element}', 'BlogAPIController@form');
                Route::apiResource('blog', 'BlogAPIController');
            });
            // Public routes for blogs
            Route::get('blog/Blog', 'BlogPublicController@getBlog');
        }
    );
}

