<?php

// web routes  for blog
Route::prefix('{guard}/blog')->group(function () {
    Route::resource('blog', 'BlogResourceController');
});

// Public routes for blog
Route::get('blogs/', 'BlogPublicController@index');
Route::get('blogs/{slug?}', 'BlogPublicController@show');

if (Trans::isMultilingual()) {
    Route::group(
        [
            'prefix' => '{trans}',
            'where'  => ['trans' => Trans::keys('|')],
        ],
        function () {
            // Guard routes for pages
            Route::prefix('{guard}/page')->group(function () {
                Route::apiResource('page', 'BlogResourceController');
            });
            // Public routes for pages
            Route::get('blogs/', 'BlogPublicController@index');
            Route::get('blogs/{slug?}', 'BlogPublicController@show');
        }
    );
}

