<?php

namespace Litecms\Blog;

use User;

class Blog
{
    /**
     * $blog object.
     */
    protected $blog;

    /**
     * Constructor.
     */
    public function __construct(\Litecms\Blog\Interfaces\BlogRepositoryInterface $blog)
    {
        $this->blog = $blog;
    }

    /**
     * Returns count of blog.
     *
     * @param array $filter
     *
     * @return int
     */
    public function count()
    {
        return  0;
    }

    /**
     * Make gadget View
     *
     * @param string $view
     *
     * @param int $count
     *
     * @return View
     */
    public function gadget($view = 'admin.blog.gadget', $count = 10)
    {

        if (User::hasRole('user')) {
            $this->blog->pushCriteria(new \Litepie\Litecms\Repositories\Criteria\BlogUserCriteria());
        }

        $blog = $this->blog->scopeQuery(function ($query) use ($count) {
            return $query->orderBy('id', 'DESC')->take($count);
        })->all();

        return view('blog::' . $view, compact('blog'))->render();
    }
}
