<?php

namespace Litecms\Blog\Repositories\Presenter;

use League\Fractal\TransformerAbstract;
use Hashids;

class BlogTransformer extends TransformerAbstract
{
    public function transform(\Litecms\Blog\Models\Blog $blog)
    {
        return [
            'id'                => $blog->getRouteKey(),
            'key'               => [
                'public'    => $blog->getPublicKey(),
                'route'     => $blog->getRouteKey(),
            ], 
            'title'             => $blog->title,
            'image'             => $blog->image,
            'upload_folder'     => $blog->upload_folder,
            'deleted_at'        => $blog->deleted_at,
            'url'               => [
                'public'    => trans_url('blog/'.$blog->getPublicKey()),
                'user'      => guard_url('blog/blog/'.$blog->getRouteKey()),
            ], 
            'status'            => trans('app.'.$blog->status),
            'created_at'        => format_date($blog->created_at),
            'updated_at'        => format_date($blog->updated_at),
        ];
    }
}