# Installation

The instructions below will help you to properly install the generated package to the lavalite project.

## Location

Extract the package contents to the folder 

`/packages/crypto/bitcoin/`

## Composer

Add the below entries in the `composer.json` file's autoload section and run the command `composer dump-autoload` in terminal.

```json

...
     "autoload": {

        "psr-4": {
            ... ,
            "Crypto\\Bitcoin\\": "packages/crypto/bitcoin/src",
            "Crypto\\Bitcoin\\Seeders\\": "packages/crypto/bitcoin/database/seeders"
            
            ...
        }
    },
...

```

## Config

Add the entries in service provider in `config/app.php`

```php

...
    'providers'       => [
        ...
        
        Crypto\Bitcoin\Providers\BitcoinServiceProvider::class,
        
        ...
    ],

    ...

    'alias'             => [
        ...
        
        'Bitcoin'  => Crypto\Bitcoin\Facades\Bitcoin::class,
        
        ...
    ]
...

```

## Migrate

After service provider is set run the commapnd to migrate and seed the database.


    php artisan migrate
    php artisan db:seed --class=Crypto\\Bitcoin\\Seeders\\BitcoinTableSeeder

## Publishing


**Publishing configuration**

    php artisan vendor:publish --provider="Crypto\Bitcoin\Providers\BitcoinServiceProvider" --tag="config"

**Publishing language**

    php artisan vendor:publish --provider="Crypto\Bitcoin\Providers\BitcoinServiceProvider" --tag="lang"

**Publishing views**

    php artisan vendor:publish --provider="Crypto\Bitcoin\Providers\BitcoinServiceProvider" --tag="view"


## URLs and APIs


### Web Urls

**Admin**

    http://path-to-route-folder/admin/bitcoin/{modulename}

**User**

    http://path-to-route-folder/user/bitcoin/{modulename}

**Public**

    http://path-to-route-folder/bitcoins


### API endpoints

**List**
 
    http://path-to-route-folder/api/user/bitcoin/{modulename}
    METHOD: GET

**Create**

    http://path-to-route-folder/api/user/bitcoin/{modulename}
    METHOD: POST

**Edit**

    http://path-to-route-folder/api/user/bitcoin/{modulename}/{id}
    METHOD: PUT

**Delete**

    http://path-to-route-folder/api/user/bitcoin/{modulename}/{id}
    METHOD: DELETE

**Public List**

    http://path-to-route-folder/api/bitcoin/{modulename}
    METHOD: GET

**Public Single**

    http://path-to-route-folder/api/bitcoin/{modulename}/{slug}
    METHOD: GET