Lavalite package that provides bitcoin management facility for the cms.

## Installation

Begin by installing this package through Composer. Edit your project's `composer.json` file to require `crypto/bitcoin`.

    "crypto/bitcoin": "dev-master"

Next, update Composer from the Terminal:

    composer update

Once this operation completes execute below cammnds in command line to finalize installation.

    Crypto\Bitcoin\Providers\BitcoinServiceProvider::class,

And also add it to alias

    'Bitcoin'  => Crypto\Bitcoin\Facades\Bitcoin::class,

## Publishing files and migraiting database.

**Migration and seeds**

    php artisan migrate
    php artisan db:seed --class=Crypto\\Bitcoin\\Seeders\\BitcoinTableSeeder

**Publishing configuration**

    php artisan vendor:publish --provider="Crypto\Bitcoin\Providers\BitcoinServiceProvider" --tag="config"

**Publishing language**

    php artisan vendor:publish --provider="Crypto\Bitcoin\Providers\BitcoinServiceProvider" --tag="lang"

**Publishing views**

    php artisan vendor:publish --provider="Crypto\Bitcoin\Providers\BitcoinServiceProvider" --tag="view"


### Web Urls

**Admin**

    http://path-to-route-folder/admin/bitcoin/{modulename}

**User**

    http://path-to-route-folder/user/bitcoin/{modulename}

**Public**

    http://path-to-route-folder/bitcoins


### API endpoints

**List**

    http://path-to-route-folder/api/user/bitcoin/{modulename}
    METHOD: GET

**Create**

    http://path-to-route-folder/api/user/bitcoin/{modulename}
    METHOD: POST

**Edit**

    http://path-to-route-folder/api/user/bitcoin/{modulename}/{id}
    METHOD: PUT

**Delete**

    http://path-to-route-folder/api/user/bitcoin/{modulename}/{id}
    METHOD: DELETE

**Public List**

    http://path-to-route-folder/api/bitcoin/{modulename}
    METHOD: GET

**Public Single**

    http://path-to-route-folder/api/bitcoin/{modulename}/{slug}
    METHOD: GET