<?php

return [

    /**
     * Provider.
     */
    'provider'  => 'superrobota',

    /*
     * Package.
     */
    'package'   => 'language',

    /*
     * Modules.
     */
    'modules'   => ['language'],

    
    'language'       => [
        'model' => [
            'model'                 => \Superrobota\Language\Models\Language::class,
            'table'                 => 'languages',
            'presenter'             => \Superrobota\Language\Repositories\Presenter\LanguagePresenter::class,
            'hidden'                => [],
            'visible'               => [],
            'guarded'               => ['*'],
            'slugs'                 => ['slug' => 'name'],
            'dates'                 => ['deleted_at', 'createdat', 'updated_at'],
            'appends'               => [],
            'fillable'              => ['name',  'lang',  'icon'],
            'translatables'         => [],
            'upload_folder'         => 'language/language',
            'uploads'               => [
            /*
                    'images' => [
                        'count' => 10,
                        'type'  => 'image',
                    ],
                    'file' => [
                        'count' => 1,
                        'type'  => 'file',
                    ],
            */
            ],

            'casts'                 => [
            /*
                'images'    => 'array',
                'file'      => 'array',
            */
            ],

            'revision'              => [],
            'perPage'               => '20',
            'search'        => [
                'name'  => 'like',
                'status',
            ]
        ],

        'controller' => [
            'provider'  => 'Superrobota',
            'package'   => 'Language',
            'module'    => 'Language',
        ],

    ],
];
