<?php

namespace Superrobota\Language;

use User;

class Language
{
    /**
     * $language object.
     */
    protected $language;

    /**
     * Constructor.
     */
    public function __construct(\Superrobota\Language\Interfaces\LanguageRepositoryInterface $language)
    {
        $this->language = $language;
    }

    /**
     * Returns count of language.
     *
     * @param array $filter
     *
     * @return int
     */
    public function count()
    {
        return  0;
    }

    /**
     * Make gadget View
     *
     * @param string $view
     *
     * @param int $count
     *
     * @return View
     */
    public function gadget($view = 'admin.language.gadget', $count = 10)
    {

        if (User::hasRole('user')) {
            $this->language->pushCriteria(new \Litepie\Superrobota\Repositories\Criteria\LanguageUserCriteria());
        }

        $language = $this->language->scopeQuery(function ($query) use ($count) {
            return $query->orderBy('id', 'DESC')->take($count);
        })->all();

        return view('language::' . $view, compact('language'))->render();
    }
}
