<?php

namespace Superrobota\Language\Policies;

use Litepie\User\Contracts\UserPolicy;
use Superrobota\Language\Models\Language;

class LanguagePolicy
{

    /**
     * Determine if the given user can view the language.
     *
     * @param UserPolicy $user
     * @param Language $language
     *
     * @return bool
     */
    public function view(UserPolicy $user, Language $language)
    {
        if ($user->canDo('language.language.view') && $user->isAdmin()) {
            return true;
        }

        return $language->user_id == user_id() && $language->user_type == user_type();
    }

    /**
     * Determine if the given user can create a language.
     *
     * @param UserPolicy $user
     * @param Language $language
     *
     * @return bool
     */
    public function create(UserPolicy $user)
    {
        return  $user->canDo('language.language.create');
    }

    /**
     * Determine if the given user can update the given language.
     *
     * @param UserPolicy $user
     * @param Language $language
     *
     * @return bool
     */
    public function update(UserPolicy $user, Language $language)
    {
        if ($user->canDo('language.language.edit') && $user->isAdmin()) {
            return true;
        }

        return $language->user_id == user_id() && $language->user_type == user_type();
    }

    /**
     * Determine if the given user can delete the given language.
     *
     * @param UserPolicy $user
     * @param Language $language
     *
     * @return bool
     */
    public function destroy(UserPolicy $user, Language $language)
    {
        return $language->user_id == user_id() && $language->user_type == user_type();
    }

    /**
     * Determine if the given user can verify the given language.
     *
     * @param UserPolicy $user
     * @param Language $language
     *
     * @return bool
     */
    public function verify(UserPolicy $user, Language $language)
    {
        if ($user->canDo('language.language.verify')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the given user can approve the given language.
     *
     * @param UserPolicy $user
     * @param Language $language
     *
     * @return bool
     */
    public function approve(UserPolicy $user, Language $language)
    {
        if ($user->canDo('language.language.approve')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the user can perform a given action ve.
     *
     * @param [type] $user    [description]
     * @param [type] $ability [description]
     *
     * @return [type] [description]
     */
    public function before($user, $ability)
    {
        if ($user->isSuperuser()) {
            return true;
        }
    }
}
