<?php

namespace Superrobota\Language\Repositories\Presenter;

use League\Fractal\TransformerAbstract;
use Hashids;

class LanguageTransformer extends TransformerAbstract
{
    public function transform(\Superrobota\Language\Models\Language $language)
    {
        return [
            'id'                => $language->getRouteKey(),
            'key'               => [
                'public'    => $language->getPublicKey(),
                'route'     => $language->getRouteKey(),
            ], 
            'name'              => $language->name,
            'lang'              => $language->lang,
            'icon'              => $language->icon,
            'url'               => [
                'public'    => trans_url('language/'.$language->getPublicKey()),
                'user'      => guard_url('language/language/'.$language->getRouteKey()),
            ], 
            'status'            => trans('app.'.$language->status),
            'created_at'        => format_date($language->created_at),
            'updated_at'        => format_date($language->updated_at),
        ];
    }
}