<?php

return [

    /**
     * Provider.
     */
    'provider'  => 'lesson',

    /*
     * Package.
     */
    'package'   => 'lesson',

    /*
     * Modules.
     */
    'modules'   => ['lessons'],

    
    'lessons'       => [
        'model' => [
            'model'                 => \Lesson\Lesson\Models\Lessons::class,
            'table'                 => 'lessons',
            'presenter'             => \Lesson\Lesson\Repositories\Presenter\LessonsPresenter::class,
            'hidden'                => [],
            'visible'               => [],
            'guarded'               => ['*'],
            'slugs'                 => ['slug' => 'name'],
            'dates'                 => ['deleted_at', 'createdat', 'updated_at'],
            'appends'               => [],
            'fillable'              => ['plan_id',  'student_id',  'teacher_id',  'date_time',  'date_time_last',  'duration_hours',  'day_of_week',  'repeating',  'payment_status',  'status',  'created_at',  'updated_at'],
            'translatables'         => [],
            'upload_folder'         => 'lesson/lessons',
            'uploads'               => [
            /*
                    'images' => [
                        'count' => 10,
                        'type'  => 'image',
                    ],
                    'file' => [
                        'count' => 1,
                        'type'  => 'file',
                    ],
            */
            ],

            'casts'                 => [
            /*
                'images'    => 'array',
                'file'      => 'array',
            */
            ],

            'revision'              => [],
            'perPage'               => '20',
            'search'        => [
                'name'  => 'like',
                'status',
            ]
        ],

        'controller' => [
            'provider'  => 'Lesson',
            'package'   => 'Lesson',
            'module'    => 'Lessons',
        ],

    ],
];
