<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;

class CreateLessonsTable extends Migration
{
    /*
     * Run the migrations.
     *
     * @return void
     */

    public function up()
    {

        /*
         * Table: lessons
         */
        Schema::create('lessons', function ($table) {
            $table->increments('id');
            $table->integer('plan_id')->nullable();
            $table->integer('student_id')->nullable();
            $table->integer('teacher_id')->nullable();
            $table->dateTime('date_time')->nullable();
            $table->dateTime('date_time_last')->nullable();
            $table->tinyInteger('duration_hours')->nullable();
            $table->tinyInteger('day_of_week')->nullable();
            $table->boolean('repeating')->nullable();
            $table->tinyInteger('payment_status')->nullable();
            $table->tinyInteger('status')->nullable();
            $table->softDeletes();
            $table->nullableTimestamps();
        });
    }

    /*
    * Reverse the migrations.
    *
    * @return void
    */

    public function down()
    {
        Schema::drop('lessons');
    }
}
