@extends('resource.show')

@php
$links['back'] = guard_url('lesson/lessons');
$links['edit'] = guard_url('lesson/lessons') . '/' . $lessons->getRouteKey() . '/edit';
@endphp

@section('icon') 
<i class="pe-7s-display2"></i>
@stop

@section('title') 
{!! __('lesson::lessons.title.main') !!}
@stop

@section('sub.title') 
{!! __('lesson::lessons.title.show') !!}
@stop

@section('breadcrumb') 
  <li><a href="{!!guard_url('/')!!}">{{ __('app.home') }}</a></li>
  <li><a href="{!!guard_url('$lesson/lessons')!!}">{!! __('lesson::lessons.name') !!}</a></li>
  <li>{{ __('app.show') }}</li>
@stop

@section('tabs') 
@stop

@section('tools') 
    <a href="{!!guard_url('$lesson/lessons')!!}" rel="tooltip" class="btn btn-white btn-round btn-simple btn-icon pull-right add-new" data-original-title="" title="">
            <i class="fa fa-chevron-left"></i>
    </a>
@stop

@section('content') 
    @include('lesson::lessons.partial.show', ['mode' => 'show'])
@stop
