<?php

namespace Lesson\Lesson\Policies;

use Litepie\User\Contracts\UserPolicy;
use Lesson\Lesson\Models\Lessons;

class LessonsPolicy
{

    /**
     * Determine if the given user can view the lessons.
     *
     * @param UserPolicy $user
     * @param Lessons $lessons
     *
     * @return bool
     */
    public function view(UserPolicy $user, Lessons $lessons)
    {
        if ($user->canDo('lesson.lessons.view') && $user->isAdmin()) {
            return true;
        }

        return $lessons->user_id == user_id() && $lessons->user_type == user_type();
    }

    /**
     * Determine if the given user can create a lessons.
     *
     * @param UserPolicy $user
     * @param Lessons $lessons
     *
     * @return bool
     */
    public function create(UserPolicy $user)
    {
        return  $user->canDo('lesson.lessons.create');
    }

    /**
     * Determine if the given user can update the given lessons.
     *
     * @param UserPolicy $user
     * @param Lessons $lessons
     *
     * @return bool
     */
    public function update(UserPolicy $user, Lessons $lessons)
    {
        if ($user->canDo('lesson.lessons.edit') && $user->isAdmin()) {
            return true;
        }

        return $lessons->user_id == user_id() && $lessons->user_type == user_type();
    }

    /**
     * Determine if the given user can delete the given lessons.
     *
     * @param UserPolicy $user
     * @param Lessons $lessons
     *
     * @return bool
     */
    public function destroy(UserPolicy $user, Lessons $lessons)
    {
        return $lessons->user_id == user_id() && $lessons->user_type == user_type();
    }

    /**
     * Determine if the given user can verify the given lessons.
     *
     * @param UserPolicy $user
     * @param Lessons $lessons
     *
     * @return bool
     */
    public function verify(UserPolicy $user, Lessons $lessons)
    {
        if ($user->canDo('lesson.lessons.verify')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the given user can approve the given lessons.
     *
     * @param UserPolicy $user
     * @param Lessons $lessons
     *
     * @return bool
     */
    public function approve(UserPolicy $user, Lessons $lessons)
    {
        if ($user->canDo('lesson.lessons.approve')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the user can perform a given action ve.
     *
     * @param [type] $user    [description]
     * @param [type] $ability [description]
     *
     * @return [type] [description]
     */
    public function before($user, $ability)
    {
        if ($user->isSuperuser()) {
            return true;
        }
    }
}
