<?php

namespace Lesson\Lesson\Repositories\Presenter;

use League\Fractal\TransformerAbstract;
use Hashids;

class LessonsTransformer extends TransformerAbstract
{
    public function transform(\Lesson\Lesson\Models\Lessons $lessons)
    {
        return [
            'id'                => $lessons->getRouteKey(),
            'key'               => [
                'public'    => $lessons->getPublicKey(),
                'route'     => $lessons->getRouteKey(),
            ], 
            'plan_id'           => $lessons->plan_id,
            'student_id'        => $lessons->student_id,
            'teacher_id'        => $lessons->teacher_id,
            'date_time'         => $lessons->date_time,
            'date_time_last'    => $lessons->date_time_last,
            'duration_hours'    => $lessons->duration_hours,
            'day_of_week'       => $lessons->day_of_week,
            'repeating'         => $lessons->repeating,
            'payment_status'    => $lessons->payment_status,
            'status'            => $lessons->status,
            'created_at'        => $lessons->created_at,
            'updated_at'        => $lessons->updated_at,
            'url'               => [
                'public'    => trans_url('lesson/'.$lessons->getPublicKey()),
                'user'      => guard_url('lesson/lessons/'.$lessons->getRouteKey()),
            ], 
            'status'            => trans('app.'.$lessons->status),
            'created_at'        => format_date($lessons->created_at),
            'updated_at'        => format_date($lessons->updated_at),
        ];
    }
}