<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;

class CreateBixoMessageMessagesTable extends Migration
{
    /*
     * Run the migrations.
     *
     * @return void
     */

    public function up()
    {

        /*
         * Table: bixo_message_messages
         */
        Schema::create('bixo_message_messages', function ($table) {
            $table->increments('id');
            $table->integer('subject_id')->nullable();
            $table->string('subject_type', 100)->nullable();
            $table->integer('lead_id')->nullable();
            $table->integer('agent_id')->nullable();
            $table->integer('team_id')->nullable();
            $table->integer('organization_id')->nullable();
            $table->integer('branch_id')->nullable();
            $table->integer('department_id')->nullable();
            $table->integer('division_id')->nullable();
            $table->string('ref_no', 50)->nullable();
            $table->string('type', 50)->nullable();
            $table->string('channel', 100)->nullable();
            $table->string('message_type', 100)->nullable();
            $table->string('name', 300)->nullable();
            $table->text('message')->nullable();
            $table->text('multimedia')->nullable();
            $table->string('branch', 50)->nullable();
            $table->string('url', 1000)->nullable();
            $table->string('mobile', 255)->nullable();
            $table->string('mobile_org', 50)->nullable();
            $table->text('details')->nullable();
            $table->text('source')->nullable();
            $table->enum('converted', ['Yes', 'No'])->nullable();
            $table->integer('count')->nullable();
            $table->text('customer_care_notes')->nullable();
            $table->tinyInteger('spam')->nullable();
            $table->integer('qualified_id')->nullable();
            $table->text('marking', 200)->nullable();
            $table->softDeletes();
            $table->nullableTimestamps();
        });
    }

    /*
    * Reverse the migrations.
    *
    * @return void
    */

    public function down()
    {
        Schema::drop('bixo_message_messages');
    }
}
