<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;

class CreateBixoMessageRecordingsTable extends Migration
{
    /*
     * Run the migrations.
     *
     * @return void
     */

    public function up()
    {

        /*
         * Table: bixo_message_recordings
         */
        Schema::create('bixo_message_recordings', function ($table) {
            $table->increments('id');
            $table->integer('user_id')->nullable();
            $table->integer('lead_id')->nullable();
            $table->integer('opportunity_id')->nullable();
            $table->string('pbx_call_id', 40)->nullable();
            $table->integer('call_id')->nullable();
            $table->dateTime('date')->nullable();
            $table->string('name', 200)->nullable();
            $table->string('from_number', 50)->nullable();
            $table->string('to_number', 50)->nullable();
            $table->string('user_name', 200)->nullable();
            $table->string('user_number', 50)->nullable();
            $table->string('customer_name', 200)->nullable();
            $table->string('customer_number', 50)->nullable();
            $table->tinyInteger('answered')->nullable();
            $table->integer('answer_time')->nullable();
            $table->integer('duration')->nullable();
            $table->string('hangup_side', 20)->nullable();
            $table->string('recording_url', 200)->nullable();
            $table->string('type', 20)->nullable();
            $table->string('status', 20)->nullable();
            $table->text('data')->nullable();
            $table->string('user_type', 30)->nullable();
            $table->text('marking', 200)->nullable();
            $table->softDeletes();
            $table->nullableTimestamps();
        });
    }

    /*
    * Reverse the migrations.
    *
    * @return void
    */

    public function down()
    {
        Schema::drop('bixo_message_recordings');
    }
}
