<?php

namespace Bixo\Message\Seeders;

use Illuminate\Support\Facades\DB;
use Illuminate\Database\Seeder;

class MessageTableSeeder extends Seeder
{
    public function run()
    {
        DB::table('bixo_message_messages')->insert([
            
        ]);

        DB::table('permissions')->insert([
            [
                'slug'      => 'bixo.message.message.view',
                'name'      => 'View Message',
            ],
            [
                'slug'      => 'bixo.message.message.create',
                'name'      => 'Create Message',
            ],
            [
                'slug'      => 'bixo.message.message.edit',
                'name'      => 'Update Message',
            ],
            [
                'slug'      => 'bixo.message.message.delete',
                'name'      => 'Delete Message',
            ],
            
            
                    ]);

        DB::table('menus')->insert([
        
            // Admin menu
            [
                'parent_id'   => 1,
                'key'         => null,
                'url'         => 'admin/message/message',
                'name'        => 'Message',
                'description' => null,
                'icon'        => 'las la-scroll',
                'target'      => null,
                'order'       => 190,
                'status'      => 1,
            ],
            
            // User menu.
            [
                'parent_id'   => 2,
                'key'         => null,
                'url'         => 'user/message/message',
                'name'        => 'Message',
                'description' => null,
                'icon'        => 'las la-scroll',
                'target'      => null,
                'order'       => 190,
                'status'      => 1,
            ],

            // Public menu.
            [
                'parent_id'   => 3,
                'key'         => null,
                'url'         => 'message',
                'name'        => 'Message',
                'description' => null,
                'icon'        => 'las la-scroll,
                'target'      => null,
                'order'       => 190,
                'status'      => 1,
            ],

        ]);

        DB::table('settings')->insert([
            // Uncomment  and edit this section for entering value to settings table.
            /*
            [
                'pacakge'   => 'Message',
                'module'    => 'Message',
                'user_type' => null,
                'user_id'   => null,
                'key'       => 'bixo.message.message.key',
                'name'      => 'Some name',
                'value'     => 'Some value',
                'type'      => 'Default',
                'control'   => 'text',
            ],
            */
        ]);
    }
}
