<?php

namespace Bixo\Message\Seeders;

use Illuminate\Support\Facades\DB;
use Illuminate\Database\Seeder;

class RecordingTableSeeder extends Seeder
{
    public function run()
    {
        DB::table('bixo_message_recordings')->insert([
            
        ]);

        DB::table('permissions')->insert([
            [
                'slug'      => 'bixo.message.recording.view',
                'name'      => 'View Recording',
            ],
            [
                'slug'      => 'bixo.message.recording.create',
                'name'      => 'Create Recording',
            ],
            [
                'slug'      => 'bixo.message.recording.edit',
                'name'      => 'Update Recording',
            ],
            [
                'slug'      => 'bixo.message.recording.delete',
                'name'      => 'Delete Recording',
            ],
            
            
                    ]);

        DB::table('menus')->insert([
        
            // Admin menu
            [
                'parent_id'   => 1,
                'key'         => null,
                'url'         => 'admin/message/recording',
                'name'        => 'Recording',
                'description' => null,
                'icon'        => 'las la-scroll',
                'target'      => null,
                'order'       => 190,
                'status'      => 1,
            ],
            
            // User menu.
            [
                'parent_id'   => 2,
                'key'         => null,
                'url'         => 'user/message/recording',
                'name'        => 'Recording',
                'description' => null,
                'icon'        => 'las la-scroll',
                'target'      => null,
                'order'       => 190,
                'status'      => 1,
            ],

            // Public menu.
            [
                'parent_id'   => 3,
                'key'         => null,
                'url'         => 'recording',
                'name'        => 'Recording',
                'description' => null,
                'icon'        => 'las la-scroll,
                'target'      => null,
                'order'       => 190,
                'status'      => 1,
            ],

        ]);

        DB::table('settings')->insert([
            // Uncomment  and edit this section for entering value to settings table.
            /*
            [
                'pacakge'   => 'Message',
                'module'    => 'Recording',
                'user_type' => null,
                'user_id'   => null,
                'key'       => 'bixo.message.recording.key',
                'name'      => 'Some name',
                'value'     => 'Some value',
                'type'      => 'Default',
                'control'   => 'text',
            ],
            */
        ]);
    }
}
