Lavalite package that provides message management facility for the cms.

## Installation

Run the below command form the root folder of lavalite.

```
    composer require "bixo/message"
```


## Migration and seeds

```
    php artisan migrate
    php artisan db:seed --class=Bixo\\Message\\Seeders\\MessageTableSeeder
```

## Publishing

* Configuration
```
    php artisan vendor:publish --provider="Bixo\Message\Providers\MessageServiceProvider" --tag="config"
```
* Language
```
    php artisan vendor:publish --provider="Bixo\Message\Providers\MessageServiceProvider" --tag="lang"
```
* Views
```
    php artisan vendor:publish --provider="Bixo\Message\Providers\MessageServiceProvider" --tag="view"
```


## URLs and APIs


### Web Urls

* Admin
```
    http://path-to-route-folder/admin/message/{modulename}
```

* User
```
    http://path-to-route-folder/user/message/{modulename}
```

* Public
```
    http://path-to-route-folder/messages
```


### API endpoints

These endpoints can be used with or without `/api/`
And also the user can be varied depend on the type of users, eg user, client, admin etc.

#### Resource

* List
```
    http://path-to-route-folder/api/user/message/{modulename}
    METHOD: GET
```

* Create
```
    http://path-to-route-folder/api/user/message/{modulename}
    METHOD: POST
```

* Edit
```
    http://path-to-route-folder/api/user/message/{modulename}/{id}
    METHOD: PUT
```

* Delete
```
    http://path-to-route-folder/api/user/message/{modulename}/{id}
    METHOD: DELETE
```

#### Public

* List
```
    http://path-to-route-folder/api/message/{modulename}
    METHOD: GET
```

* Single Item
```
    http://path-to-route-folder/api/message/{modulename}/{slug}
    METHOD: GET
```

#### Others

* Report
```
    http://path-to-route-folder/api/user/message/{modulename}/report/{report}
    METHOD: GET
```

* Export/Import
```
    http://path-to-route-folder/api/user/message/{modulename}/exim/{exim}
    METHOD: POST
```

* Action
```
    http://path-to-route-folder/api/user/message/{modulename}/action/{id}/{action}
    METHOD: PATCH
```

* Actions
```
    http://path-to-route-folder/api/user/message/{modulename}/actions/{action}
    METHOD: PATCH
```

* Workflow
```
    http://path-to-route-folder/api/user/message/{modulename}/workflow/{id}/{transition}
    METHOD: PATCH
```
