@include('message::public.message.partial.header')
<section class="listing-page-wrap">
    <div class="container">
        <div class="row">
            @include('message::public.message.partial.aside')

            <div class="col-12 col-lg-9 left-sidebar" id="listing_data">
                @forelse($messages as $message)
                @php 
                $message = $message->toArray([]);
                @endphp
                <div class="listing-single-item d-flex align-items-center flex-wrap">
                    <div class="col-12 col-lg-5 p-0 listing-image">
                        <a href="{{trans_url('message')}}/{{$message['slug']}}">
                        <img src="{{url($message['image']['main'])}}" class="img-fluid" alt="">
                        </a>
                    </div>
                    <div class="col-12 col-lg-6 p-0 listing-text">
                        <div class="listing-content">
                            <h3><a href="{{trans_url('message')}}/{{$message['slug']}}">{{$message['title']}}</a></h3>
                            <div class="listing-metas">
                                <span>By <a
                                        href="{{trans_url('message')}}/{{$message['slug']}}">User</a></span>
                                <span><a
                                        href="{{trans_url('message')}}/{{$message['slug']}}">Category</a></span>
                            </div>
                            <p>{{ Str::limit($message['description'], 300 )}}</p>
                        </div>
                        <a href="{{trans_url('message')}}/{{$message['slug']}}" class="btn btn-theme">Continue Reading</a>
                    </div>
                </div>
                <nav class="pagination-wrap mb-50" aria-label="Page navigation example">
                    <ul class="pagination">
                        @php 
                        $meta = $message['meta'];
                        @endphp
                        {!!view('paginator', compact('meta'))!!}
                    </ul>
                </nav>
                @empty
                @endif
            </div>
        </div>
    </div>
</section>
