<?php

namespace Bixo\Message\Actions;

use Illuminate\Support\Carbon;
use Illuminate\Support\Str;
use Litepie\Actions\Concerns\AsAction;
use Bixo\Message\Models\Message;


class MessageAction
{
    use AsAction;

    protected $model;
    protected $namespace = 'bixo.message.message';
    protected $eventClass = \Bixo\Message\Events\MessageAction::class;
    protected $action;
    protected $function;
    protected $request;

    public function handle(string $action, Message $message, array $request = [])
    {
        $this->action = $action;
        $this->request = $request;
        $this->model = $message;
        $this->function = Str::camel($action);
        $this->executeAction();
        return $this->model;

    }


    public function store(Message $message, array $request)
    {
        $attributes = $request;
        $attributes['user_id'] = user_id();
        $attributes['user_type'] = user_type();
        $message = $message->create($attributes);
        return $message;
    }

    public function update(Message $message, array $request)
    {
        $attributes = $request;
        $message->update($attributes);
        return $message;
    }

    public function destroy(Message $message, array $request)
    {
        $message->delete();
        return $message;
    }

    public function copy(Message $message, array $request)
    {
        $count = $request['count'] ?: 1;

        if ($count == 1) {
            $message = $message->replicate();
            $message->created_at = Carbon::now();
            $message->save();
            return $message;
        }

        for ($i = 1; $i <= $count; $i++) {
            $new = $message->replicate();
            $new->created_at = Carbon::now();
            $new->save();
        }

        return $message;
    }


}
