<?php

namespace Bixo\Message\Actions;

use Illuminate\Support\Carbon;
use Illuminate\Support\Str;
use Litepie\Actions\Concerns\AsAction;
use Bixo\Message\Models\Recording;


class RecordingAction
{
    use AsAction;

    protected $model;
    protected $namespace = 'bixo.message.recording';
    protected $eventClass = \Bixo\Message\Events\RecordingAction::class;
    protected $action;
    protected $function;
    protected $request;

    public function handle(string $action, Recording $recording, array $request = [])
    {
        $this->action = $action;
        $this->request = $request;
        $this->model = $recording;
        $this->function = Str::camel($action);
        $this->executeAction();
        return $this->model;

    }


    public function store(Recording $recording, array $request)
    {
        $attributes = $request;
        $attributes['user_id'] = user_id();
        $attributes['user_type'] = user_type();
        $recording = $recording->create($attributes);
        return $recording;
    }

    public function update(Recording $recording, array $request)
    {
        $attributes = $request;
        $recording->update($attributes);
        return $recording;
    }

    public function destroy(Recording $recording, array $request)
    {
        $recording->delete();
        return $recording;
    }

    public function copy(Recording $recording, array $request)
    {
        $count = $request['count'] ?: 1;

        if ($count == 1) {
            $recording = $recording->replicate();
            $recording->created_at = Carbon::now();
            $recording->save();
            return $recording;
        }

        for ($i = 1; $i <= $count; $i++) {
            $new = $recording->replicate();
            $new->created_at = Carbon::now();
            $new->save();
        }

        return $recording;
    }


}
