<?php

namespace Bixo\Message\Http\Controllers;

use App\Http\Controllers\PublicController as BaseController;
use App\Http\Requests\PublicRequest;
use Litepie\Database\RequestScope;
use Bixo\Message\Http\Resources\MessageResource;
use Bixo\Message\Http\Resources\MessagesCollection;
use Bixo\Message\Scopes\MessagePublicScope;
use Bixo\Message\Models\Message;

class MessagePublicController extends BaseController
{

    /**
     * Show message's list.
     *
     * @return response
     */
    protected function index(PublicRequest $request)
    {

        $search = $request->search;
        $pageLimit = $request->input('pageLimit', config('database.pagination.limit'));
        $page = Message::pushScope(new RequestScope())
            ->pushScope(new MessagePublicScope())
            ->paginate($pageLimit)
            ->withQueryString();

        $messages = new MessagesCollection($page);

        $categories = [];
        $tags = [];
        $recent = [];

        return $this->response->setMetaTitle(trans('message::message.names'))
            ->view('message::public.message.index')
            ->data(compact('messages', 'categories', 'tags', 'recent'))
            ->output();
    }

    /**
     * Show message.
     *
     * @param string $slug
     *
     * @return response
     */
    protected function show(PublicRequest $request, $slug)
    {
        $model = Message::findBySlug($slug);
        $data = new MessageResource($model);

        $categories = [];
        $tags = [];
        $recent = [];
    
        return $this->response->setMetaTitle($data['title'] . trans('message::message.name'))
            ->view('message::public.message.show')
            ->data(compact('data', 'categories', 'tags', 'recent'))
            ->output();
    }

}
