<?php

namespace Bixo\Message\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class MessageResource extends JsonResource
{

    public function itemLink()
    {
        return guard_url('message/message') . '/' . $this->getRouteKey();
    }

    public function title()
    {
        if ($this->title != '') {
            return $this->title;
        }

        if ($this->name != '') {
            return $this->name;
        }

        return 'None';
    }

    public function toArray($request)
    {
        return [
            'id' => $this->getRouteKey(),
            'title' => $this->title(),
            'slug' => $this->slug,
            'subject_id' => $this->subject_id,
            'subject_type' => $this->subject_type,
            'lead_id' => $this->lead_id,
            'agent_id' => $this->agent_id,
            'team_id' => $this->team_id,
            'organization_id' => $this->organization_id,
            'branch_id' => $this->branch_id,
            'department_id' => $this->department_id,
            'division_id' => $this->division_id,
            'ref_no' => $this->ref_no,
            'type' => $this->type,
            'channel' => $this->channel,
            'message_type' => $this->message_type,
            'name' => $this->name,
            'message' => $this->message,
            'multimedia' => $this->multimedia,
            'branch' => $this->branch,
            'url' => $this->url,
            'mobile' => $this->mobile,
            'mobile_org' => $this->mobile_org,
            'details' => $this->details,
            'source' => $this->source,
            'converted' => $this->converted,
            'count' => $this->count,
            'customer_care_notes' => $this->customer_care_notes,
            'spam' => $this->spam,
            'qualified_id' => $this->qualified_id,
            'created_at' => !is_null($this->created_at) ? $this->created_at->format('Y-m-d H:i:s') : null,
            'updated_at' => !is_null($this->updated_at) ? $this->updated_at->format('Y-m-d H:i:s') : null,
            'meta' => [
                'exists' => $this->exists(),
                'link' => $this->itemLink(),
                'upload_url' => $this->getUploadURL(''),
                'workflow' => $this->workflows(),
                'actions' => $this->actions(),
            ],
        ];
    }

    /**
     * Get additional data that should be returned with the resource array.
     *
     * @param     \Illuminate\Http\Request  $request
     * @return array
     */
    public function with($request)
    {
        return [
            'meta' => [
                'exists' => $this->exists(),
                'link' => $this->itemLink(),
                'upload_url' => $this->getUploadURL(''),
                'workflow' => $this->workflows(),
                'actions' => $this->actions(),
            ],
        ];
    }

    /**
     * Get the workflows for the resource.
     *
     * @return array
     */
    private function workflows()
    {
        $arr = [];
                return $arr;

    }
    
    /**
     * Get the actions for the resource.
     *
     * @return array
     */
    private function actions()
    {

        $arr = [];
        
        return $arr;
    }
}
