<?php

namespace Bixo\Message\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class RecordingResource extends JsonResource
{

    public function itemLink()
    {
        return guard_url('message/recording') . '/' . $this->getRouteKey();
    }

    public function title()
    {
        if ($this->title != '') {
            return $this->title;
        }

        if ($this->name != '') {
            return $this->name;
        }

        return 'None';
    }

    public function toArray($request)
    {
        return [
            'id' => $this->getRouteKey(),
            'title' => $this->title(),
            'slug' => $this->slug,
            'user_id' => $this->user_id,
            'lead_id' => $this->lead_id,
            'opportunity_id' => $this->opportunity_id,
            'pbx_call_id' => $this->pbx_call_id,
            'call_id' => $this->call_id,
            'date' => $this->date,
            'name' => $this->name,
            'from_number' => $this->from_number,
            'to_number' => $this->to_number,
            'user_name' => $this->user_name,
            'user_number' => $this->user_number,
            'customer_name' => $this->customer_name,
            'customer_number' => $this->customer_number,
            'answered' => $this->answered,
            'answer_time' => $this->answer_time,
            'duration' => $this->duration,
            'hangup_side' => $this->hangup_side,
            'recording_url' => $this->recording_url,
            'type' => $this->type,
            'status' => $this->status,
            'data' => $this->data,
            'user_type' => $this->user_type,
            'created_at' => !is_null($this->created_at) ? $this->created_at->format('Y-m-d H:i:s') : null,
            'updated_at' => !is_null($this->updated_at) ? $this->updated_at->format('Y-m-d H:i:s') : null,
            'meta' => [
                'exists' => $this->exists(),
                'link' => $this->itemLink(),
                'upload_url' => $this->getUploadURL(''),
                'workflow' => $this->workflows(),
                'actions' => $this->actions(),
            ],
        ];
    }

    /**
     * Get additional data that should be returned with the resource array.
     *
     * @param     \Illuminate\Http\Request  $request
     * @return array
     */
    public function with($request)
    {
        return [
            'meta' => [
                'exists' => $this->exists(),
                'link' => $this->itemLink(),
                'upload_url' => $this->getUploadURL(''),
                'workflow' => $this->workflows(),
                'actions' => $this->actions(),
            ],
        ];
    }

    /**
     * Get the workflows for the resource.
     *
     * @return array
     */
    private function workflows()
    {
        $arr = [];
                return $arr;

    }
    
    /**
     * Get the actions for the resource.
     *
     * @return array
     */
    private function actions()
    {

        $arr = [];
        
        return $arr;
    }
}
