<?php

namespace Bixo\Message\Listeners;

use Illuminate\Support\Facades\Notification;
use Illuminate\Support\Str;
use Bixo\Message\Events\MessageAction as MessageActionEvent;
use Bixo\Message\Notifications\MessageAction as MessageActionNotification;
use Litepie\Actions\Concerns\AsAction;

class MessageAction
{
    use AsAction;

    private $allowedActions = [
        'before' => [],
        'after' => ['create'],
    ];

    /**
     * Handle the MessageActionEvent.
     *
     * @param   MessageActionEvent  $event
     * @return mixed
     */
    public function handle(MessageActionEvent $event)
    {
        $function = Str::camel($event->action);
        return $this->$function($event);
    }

    /**
     * Create a new $message.
     *
     * @param   MessageActionEvent  $event
     * @return void
     */
    public function create(MessageActionEvent $event)
    {
        $client = $event->message->client;
        Notification::send($client, new MessageActionNotification($event));
    }

    /**
     * Handle the MessageActionEvent as a listener.
     *
     * @param   MessageActionEvent  $event
     * @return mixed
     */
    public function asListener(MessageActionEvent $event)
    {
        if ($this->isAllowed($event)) {
            return $this->handle($event);
        }
    }

    /**
     * Check if the event action is allowed.
     *
     * @param   MessageActionEvent  $event
     * @return bool
     */
    private function isAllowed(MessageActionEvent $event)
    {
        if ($event->when == 'before' &&
            !in_array($event->action, $this->allowedActions['before'])) {
            return false;
        }

        if (($event->when == 'after' &&
            !in_array($event->action, $this->allowedActions['after']))
        ) {
            return false;
        }

        return true;
    }
}
