<?php

namespace Bixo\Message\Listeners;

use Illuminate\Support\Facades\Notification;
use Illuminate\Support\Str;
use Bixo\Message\Events\RecordingAction as RecordingActionEvent;
use Bixo\Message\Notifications\RecordingAction as RecordingActionNotification;
use Litepie\Actions\Concerns\AsAction;

class RecordingAction
{
    use AsAction;

    private $allowedActions = [
        'before' => [],
        'after' => ['create'],
    ];

    /**
     * Handle the RecordingActionEvent.
     *
     * @param   RecordingActionEvent  $event
     * @return mixed
     */
    public function handle(RecordingActionEvent $event)
    {
        $function = Str::camel($event->action);
        return $this->$function($event);
    }

    /**
     * Create a new $recording.
     *
     * @param   RecordingActionEvent  $event
     * @return void
     */
    public function create(RecordingActionEvent $event)
    {
        $client = $event->recording->client;
        Notification::send($client, new RecordingActionNotification($event));
    }

    /**
     * Handle the RecordingActionEvent as a listener.
     *
     * @param   RecordingActionEvent  $event
     * @return mixed
     */
    public function asListener(RecordingActionEvent $event)
    {
        if ($this->isAllowed($event)) {
            return $this->handle($event);
        }
    }

    /**
     * Check if the event action is allowed.
     *
     * @param   RecordingActionEvent  $event
     * @return bool
     */
    private function isAllowed(RecordingActionEvent $event)
    {
        if ($event->when == 'before' &&
            !in_array($event->action, $this->allowedActions['before'])) {
            return false;
        }

        if (($event->when == 'after' &&
            !in_array($event->action, $this->allowedActions['after']))
        ) {
            return false;
        }

        return true;
    }
}
