<?php

namespace Bixo\Message\Policies;

use Illuminate\Foundation\Auth\User as Authenticatable;
use Bixo\Message\Models\Message;

class MessagePolicy
{


    /**
     * Determine if the given user can view the message.
     *
     * @param Authenticatable $user
     * @param Message $message
     *
     * @return bool
     */
    public function view(Authenticatable $user, Message $message)
    {
        if ($authUser->canDo('message.message.view') && $authUser->isAdmin() || $user->isClient()) {
            return true;
        }

        return $message->is_owner;
    }

    /**
     * Determine if the given user can create a message.
     *
     * @param Authenticatable $user
     *
     * @return bool
     */
    public function create(Authenticatable $user)
    {
        return  $authUser->canDo('message.message.create');
    }

    /**
     * Determine if the given user can update the given message.
     *
     * @param Authenticatable $user
     * @param Message $message
     *
     * @return bool
     */
    public function update(Authenticatable $user, Message $message)
    {
        if ($user->canDo('message.message.edit') && $user->isAdmin()) {
            return true;
        }

        return $message->is_owner;
    }

    /**
     * Determine if the given user can delete the given message.
     *
     * @param Authenticatable $user
     *
     * @return bool
     */
    public function destroy(Authenticatable $user, Message $message)
    {
        return $message->is_owner;
    }

    /**
     * Determine if the user can perform a given action ve.
     *
     * @param [type] $user    [description]
     * @param [type] $ability [description]
     *
     * @return [type] [description]
     */
    public function before($user, $ability)
    {
        if ($user->isSuperuser()) {
            return true;
        }
    }
}
