<?php

namespace Bixo\Message\Policies;

use Illuminate\Foundation\Auth\User as Authenticatable;
use Bixo\Message\Models\Recording;

class RecordingPolicy
{


    /**
     * Determine if the given user can view the recording.
     *
     * @param Authenticatable $user
     * @param Recording $recording
     *
     * @return bool
     */
    public function view(Authenticatable $user, Recording $recording)
    {
        if ($authUser->canDo('message.recording.view') && $authUser->isAdmin() || $user->isClient()) {
            return true;
        }

        return $recording->is_owner;
    }

    /**
     * Determine if the given user can create a recording.
     *
     * @param Authenticatable $user
     *
     * @return bool
     */
    public function create(Authenticatable $user)
    {
        return  $authUser->canDo('message.recording.create');
    }

    /**
     * Determine if the given user can update the given recording.
     *
     * @param Authenticatable $user
     * @param Recording $recording
     *
     * @return bool
     */
    public function update(Authenticatable $user, Recording $recording)
    {
        if ($user->canDo('message.recording.edit') && $user->isAdmin()) {
            return true;
        }

        return $recording->is_owner;
    }

    /**
     * Determine if the given user can delete the given recording.
     *
     * @param Authenticatable $user
     *
     * @return bool
     */
    public function destroy(Authenticatable $user, Recording $recording)
    {
        return $recording->is_owner;
    }

    /**
     * Determine if the user can perform a given action ve.
     *
     * @param [type] $user    [description]
     * @param [type] $ability [description]
     *
     * @return [type] [description]
     */
    public function before($user, $ability)
    {
        if ($user->isSuperuser()) {
            return true;
        }
    }
}
