<?php

namespace Bixo\Message\Providers;

use Illuminate\Contracts\Auth\Access\Gate as GateContract;
use Illuminate\Foundation\Support\Providers\AuthServiceProvider as ServiceProvider;

class AuthServiceProvider extends ServiceProvider
{
    /**
     * The policy mappings for the package.
     *
     * @var array
     */
    protected $policies = [
        // Bind Message policy
        \Bixo\Message\Models\Message::class 
        => \Bixo\Message\Policies\MessagePolicy::class,// Bind Recording policy
        \Bixo\Message\Models\Recording::class 
        => \Bixo\Message\Policies\RecordingPolicy::class,
    ];

    /**
     * Register any package authentication / authorization services.
     *
     * @param \Illuminate\Contracts\Auth\Access\Gate $gate
     *
     * @return void
     */
    public function boot(GateContract $gate)
    {
        parent::registerPolicies($gate);
    }
}
