<?php

namespace Bixo\Message\Providers;

use Illuminate\Foundation\Support\Providers\EventServiceProvider as ServiceProvider;
use Bixo\Message\Events\MessageAction;
use Bixo\Message\Events\MessageWorkflow;
use Bixo\Message\Listeners\MessageAction as MessageActionListener;
use Bixo\Message\Listeners\MessageWorkflow as MessageWorkflowListener;


class EventServiceProvider extends ServiceProvider
{
    /**
     * The event listener mappings for the application.
     *
     * @var array
     */
    protected $listen = [
    
        MessageAction::class => [
            MessageActionListener::class,
        ],
        MessageWorkflow::class => [
            MessageWorkflowListener::class,
        ],
    ];

    /**
     * Register any other events for your application.
     *
     * @param \Illuminate\Contracts\Events\Dispatcher $events
     *
     * @return void
     */
    public function boot()
    {
        parent::boot();

        //
    }
}
