<?php

namespace Bixo\Message\Providers;

use Illuminate\Support\ServiceProvider;
use Bixo\Message\Messages;

class MessageServiceProvider extends ServiceProvider
{
    /**
     * Indicates if loading of the provider is deferred.
     *
     * @var bool
     */
    protected $defer = true;

    /**
     * Bootstrap the application events.
     *
     * @return void
     */
    public function boot()
    {
        // Load view
        $this->loadViewsFrom(__DIR__ . '/../../resources/views', 'message');

        // Load translation
        $this->loadTranslationsFrom(__DIR__ . '/../../resources/lang', 'message');

        // Load migrations
        $this->loadMigrationsFrom(__DIR__ . '/../../database/migrations');

        // Call pblish redources function
        $this->publishResources();

    }

    /**
     * Register the service provider.
     *
     * @return void
     */
    public function register()
    {
        $this->mergeConfig();
        $this->registerFacade();

        $this->app->register(\Bixo\Message\Providers\AuthServiceProvider::class);
        $this->app->register(\Bixo\Message\Providers\RouteServiceProvider::class);
        $this->app->register(\Bixo\Message\Providers\EventServiceProvider::class);
    }

    /**
     * Register the vault facade without the user having to add it to the app.php file.
     *
     * @return void
     */
    public function registerFacade() {
        $this->app->bind('bixo.message', function($app)
        {
            return $this->app->make(Message::class);
        });
    }

    /**
     * Merges user's and message's configs.
     *
     * @return void
     */
    protected function mergeConfig()
    {
        $this->mergeConfigFrom(
            __DIR__ . '/../../config/config.php', 'bixo.message'
        );
        
        $this->mergeConfigFrom(
            __DIR__ . '/../../config/message.php', 'bixo.message.message'
        );
        $this->mergeConfigFrom(
            __DIR__ . '/../../config/recording.php', 'bixo.message.recording'
        );
    }


    /**
     * Get the services provided by the provider.
     *
     * @return array
     */
    public function provides()
    {
        return ['bixo.message'];
    }

    /**
     * Publish resources.
     *
     * @return void
     */
    private function publishResources()
    {
        // Publish configuration file
        $this->publishes([__DIR__ . '/../../config/' => config_path('bixo/message')], 'config');

        // Publish admin view
        $this->publishes([__DIR__ . '/../../resources/views' => base_path('resources/views/vendor/message')], 'view');

        // Publish language files
        $this->publishes([__DIR__ . '/../../resources/lang' => base_path('resources/lang/vendor/message')], 'lang');

        // Publish public files and assets.
        $this->publishes([__DIR__ . '/public/' => public_path('/')], 'public');
    }
}
