@extends('resource.show')

@php
$links['back'] = guard_url('john_package/project');
$links['edit'] = guard_url('john_package/project') . '/' . $project->getRouteKey() . '/edit';
@endphp

@section('icon') 
<i class="pe-7s-display2"></i>
@stop

@section('title') 
{!! __('john_package::project.title.main') !!}
@stop

@section('sub.title') 
{!! __('john_package::project.title.show') !!}
@stop

@section('breadcrumb') 
  <li><a href="{!!guard_url('/')!!}">{{ __('app.home') }}</a></li>
  <li><a href="{!!guard_url('$john_package/project')!!}">{!! __('john_package::project.name') !!}</a></li>
  <li>{{ __('app.show') }}</li>
@stop

@section('tabs') 
@stop

@section('tools') 
    <a href="{!!guard_url('$john_package/project')!!}" rel="tooltip" class="btn btn-white btn-round btn-simple btn-icon pull-right add-new" data-original-title="" title="">
            <i class="fa fa-chevron-left"></i>
    </a>
@stop

@section('content') 
    @include('john_package::project.partial.show', ['mode' => 'show'])
@stop
