<?php

namespace John\JohnPackage\Http\Controllers;

use App\Http\Controllers\Controller as BaseController;
use John\JohnPackage\Http\Requests\ProjectRequest;
use John\JohnPackage\Models\Project;

/**
 * Admin web controller class.
 */
class ProjectWorkflowController extends BaseController
{

    /**
     * Workflow controller function for project.
     *
     * @param Model   $project
     * @param step    next step for the workflow.
     *
     * @return Response
     */

    public function putWorkflow(ProjectRequest $request, Project $project, $step)
    {

        try {

            $project->updateWorkflow($step);

            return response()->json([
                'message'  => trans('messages.success.changed', ['Module' => trans('john_package::project.name'), 'status' => trans("app.{$step}")]),
                'code'     => 204,
                'redirect' => trans_url('/admin/project/project/' . $project->getRouteKey()),
            ], 201);

        } catch (Exception $e) {

            return response()->json([
                'message'  => $e->getMessage(),
                'code'     => 400,
                'redirect' => trans_url('/admin/project/project/' . $project->getRouteKey()),
            ], 400);

        }

    }

    /**
     * Workflow controller function for project.
     *
     * @param Model   $project
     * @param step    next step for the workflow.
     * @param user    encrypted user id.
     *
     * @return Response
     */

    public function getWorkflow(Project $project, $step, $user)
    {
        try {
            $user_id = decrypt($user);

            Auth::onceUsingId($user_id);

            $project->updateWorkflow($step);

            $data = [
                'message' => trans('messages.success.changed', ['Module' => trans('john_package::project.name'), 'status' => trans("app.{$step}")]),
                'status'  => 'success',
                'step'    => trans("app.{$step}"),
            ];

            return $this->theme->layout('blank')->of('john_package::admin.project.message', $data)->render();

        } catch (ValidationException $e) {

            $data = [
                'message' => '<b>' . $e->getMessage() . '</b> <br /><br />' . implode('<br />', $e->validator->errors()->all()),
                'status'  => 'error',
                'step'    => trans("app.{$step}"),
            ];

            return $this->theme->layout('blank')->of('john_package::admin.project.message', $data)->render();

        } catch (Exception $e) {

            $data = [
                'message' => '<b>' . $e->getMessage() . '</b>',
                'status'  => 'error',
                'step'    => trans("app.{$step}"),
            ];

            return $this->theme->layout('blank')->of('john_package::admin.project.message', $data)->render();

        }

    }
}
