<?php

namespace John\JohnPackage\Policies;

use Litepie\User\Contracts\UserPolicy;
use John\JohnPackage\Models\Project;

class ProjectPolicy
{

    /**
     * Determine if the given user can view the project.
     *
     * @param UserPolicy $user
     * @param Project $project
     *
     * @return bool
     */
    public function view(UserPolicy $user, Project $project)
    {
        if ($user->canDo('john_package.project.view') && $user->isAdmin()) {
            return true;
        }

        return $project->user_id == user_id() && $project->user_type == user_type();
    }

    /**
     * Determine if the given user can create a project.
     *
     * @param UserPolicy $user
     * @param Project $project
     *
     * @return bool
     */
    public function create(UserPolicy $user)
    {
        return  $user->canDo('john_package.project.create');
    }

    /**
     * Determine if the given user can update the given project.
     *
     * @param UserPolicy $user
     * @param Project $project
     *
     * @return bool
     */
    public function update(UserPolicy $user, Project $project)
    {
        if ($user->canDo('john_package.project.edit') && $user->isAdmin()) {
            return true;
        }

        return $project->user_id == user_id() && $project->user_type == user_type();
    }

    /**
     * Determine if the given user can delete the given project.
     *
     * @param UserPolicy $user
     * @param Project $project
     *
     * @return bool
     */
    public function destroy(UserPolicy $user, Project $project)
    {
        return $project->user_id == user_id() && $project->user_type == user_type();
    }

    /**
     * Determine if the given user can verify the given project.
     *
     * @param UserPolicy $user
     * @param Project $project
     *
     * @return bool
     */
    public function verify(UserPolicy $user, Project $project)
    {
        if ($user->canDo('john_package.project.verify')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the given user can approve the given project.
     *
     * @param UserPolicy $user
     * @param Project $project
     *
     * @return bool
     */
    public function approve(UserPolicy $user, Project $project)
    {
        if ($user->canDo('john_package.project.approve')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the user can perform a given action ve.
     *
     * @param [type] $user    [description]
     * @param [type] $ability [description]
     *
     * @return [type] [description]
     */
    public function before($user, $ability)
    {
        if ($user->isSuperuser()) {
            return true;
        }
    }
}
