<?php

namespace John\JohnPackage\Providers;

use Illuminate\Support\ServiceProvider;

class JohnPackageServiceProvider extends ServiceProvider
{
    /**
     * Indicates if loading of the provider is deferred.
     *
     * @var bool
     */
    protected $defer = false;

    /**
     * Bootstrap the application events.
     *
     * @return void
     */
    public function boot()
    {
        // Load view
        $this->loadViewsFrom(__DIR__ . '/../../resources/views', 'john_package');

        // Load translation
        $this->loadTranslationsFrom(__DIR__ . '/../../resources/lang', 'john_package');

        // Load migrations
        $this->loadMigrationsFrom(__DIR__ . '/../../database/migrations');

        // Call pblish redources function
        $this->publishResources();

    }

    /**
     * Register the service provider.
     *
     * @return void
     */
    public function register()
    {
        $this->mergeConfig();
        $this->registerJohnPackage();
        $this->registerFacade();
        $this->registerBindings();
        //$this->registerCommands();
    }


    /**
     * Register the application bindings.
     *
     * @return void
     */
    protected function registerJohnPackage()
    {
        $this->app->bind('john_package', function($app) {
            return new JohnPackage($app);
        });
    }

    /**
     * Register the vault facade without the user having to add it to the app.php file.
     *
     * @return void
     */
    public function registerFacade() {
        $this->app->booting(function()
        {
            $loader = \Illuminate\Foundation\AliasLoader::getInstance();
            $loader->alias('JohnPackage', 'Lavalite\JohnPackage\Facades\JohnPackage');
        });
    }

    /**
     * Register bindings for the provider.
     *
     * @return void
     */
    public function registerBindings() {
        // Bind facade
        $this->app->bind('john.john_package', function ($app) {
            return $this->app->make('John\JohnPackage\JohnPackage');
        });

                // Bind Project to repository
        $this->app->bind(
            'John\JohnPackage\Interfaces\ProjectRepositoryInterface',
            \John\JohnPackage\Repositories\Eloquent\ProjectRepository::class
        );

        $this->app->register(\John\JohnPackage\Providers\AuthServiceProvider::class);
        
        $this->app->register(\John\JohnPackage\Providers\RouteServiceProvider::class);
                $this->app->register(\John\JohnPackage\Providers\WorkflowServiceProvider::class);
            }

    /**
     * Merges user's and john_package's configs.
     *
     * @return void
     */
    protected function mergeConfig()
    {
        $this->mergeConfigFrom(
            __DIR__ . '/../../config/john_package.php', 'john_package'
        );
    }

    /**
     * Register scaffolding command
     */
    protected function registerCommands()
    {
        if ($this->app->runningInConsole()) {
            $this->commands([
                Commands\MakeJohnPackage::class,
            ]);
        }
    }
    /**
     * Get the services provided by the provider.
     *
     * @return array
     */
    public function provides()
    {
        return ['john.john_package'];
    }

    /**
     * Publish resources.
     *
     * @return void
     */
    private function publishResources()
    {
        // Publish configuration file
        $this->publishes([__DIR__ . '/../../config/config.php' => config_path('john/john_package.php')], 'config');

        // Publish admin view
        $this->publishes([__DIR__ . '/../../resources/views' => base_path('resources/views/vendor/john_package')], 'view');

        // Publish language files
        $this->publishes([__DIR__ . '/../../resources/lang' => base_path('resources/lang/vendor/john_package')], 'lang');

        // Publish public files and assets.
        $this->publishes([__DIR__ . '/public/' => public_path('/')], 'public');
    }
}
